<?php
/**
 * @author: Nexi Payments SpA
 * @copyright: © 2017, Nexi Payments SpA
 * @license: GNU General Public License v3.0
 */

class NexiXPayRitornoModuleFrontController extends ModuleFrontController
{

    public $ssl = true;
    public $display_column_left = false;

    /**
     * @see FrontController::postProcess()
     */
    public function postProcess()
    {
        $paymentGateway = $this->module->getConfiguration();

        $rfo = new NexiXPayResponse();

        $rfo->setMacKey($paymentGateway->nexi_mac);

        $rfo->setAlias(Tools::getValue('alias'));
        $rfo->setImporto(Tools::getValue('importo'));
        $rfo->setDivisa(Tools::getValue('divisa'));
        $rfo->setCodTrans(Tools::getValue('codTrans'));
        $rfo->setSessionId(Tools::getValue('session_id'));
        $rfo->setBrand(Tools::getValue('brand'));
        $rfo->setNome(Tools::getValue('nome'));
        $rfo->setCognome(Tools::getValue('cognome'));
        $rfo->setMail(Tools::getValue('mail'));
        $rfo->setMac(Tools::getValue('mac'));
        $rfo->setEsito(Tools::getValue('esito'));
        $rfo->setData(Tools::getValue('data'));
        $rfo->setOrario(Tools::getValue('orario'));
        $rfo->setCodAut(Tools::getValue('codAut'));
        $rfo->setPan(Tools::getValue('pan'));
        $rfo->setScadenzaPan(Tools::getValue('scadenza_pan'));
        $rfo->setRegione(Tools::getValue('regione'));
        $rfo->setNazionalita(Tools::getValue('nazionalita'));
        $rfo->setMessaggio(Tools::getValue('messaggio'));
        $rfo->setHash(Tools::getValue('hash'));
        $rfo->setCheck(Tools::getValue('check'));
        $rfo->setDescrizione(Tools::getValue('descrizione'));
        $rfo->setLanguageId(Tools::getValue('languageId'));


        $rfo->calculateMac();

        if ($rfo->responseVerified() && Tools::strtolower($rfo->getEsito()) == 'ok') {
            $arr_exploded = explode('_', $rfo->getCodTrans());

            if (count($arr_exploded) > 1) {
                $id_cart = $arr_exploded[1];
                $cart = new Cart($id_cart);
                $this->context->cart = $cart;

                if ($cart->id_customer == 0 || $cart->id_address_delivery == 0 ||
                        $cart->id_address_invoice == 0 || !$this->module->active) {
                    Tools::redirect('index.php?controller=order&step=1');
                }

                $customer = new Customer($cart->id_customer);
                if (!Validate::isLoadedObject($customer)) {
                    Tools::redirect('index.php?controller=order&step=1');
                }
                
                $totalCS = $rfo->getImporto() / 100;
                $totalCart = $cart->getOrderTotal(true, Cart::BOTH);
                if ($totalCS != $totalCart) {
                    $this->context->smarty->assign(array(
                        'error' => "Avviso: " . $totalCS . " € pagati al posto di " . $totalCart . " €",
                    ));

                    $this->setTemplate("module:nexixpay/views/templates/front/payment_error.tpl");
                } else {
                    Tools::redirect(
                        'index.php?controller=order-confirmation&id_cart=' . $cart->id .
                        '&id_module=' . $this->module->id . '&id_order=' . $this->module->currentOrder .
                        '&key=' . $customer->secure_key
                    );
                }
            } else {
                $this->context->smarty->assign(array(
                    'error' => $this->module->l('Cart not found.'),
                ));
            }
        } else {
            $this->context->smarty->assign(array(
                'error' => $rfo->getMessaggio(),
            ));

            $this->setTemplate("payment_error.tpl");
        }
    }
}
